using System;
using System.Collections;
using System.Threading;

using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/6/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Summary description for LogonUser.</summary>

	#endregion

	public class LogonUser
	{
		/// <summary>
		/// Has the division code for everyone static so that it is the same everywhere
		/// </summary>
		private static string _logonUserDivisionCode;

		private static System.Guid _vbecsSessionGuid = System.Guid.Empty;

		private static string _logonUserDuz;

		private static Hashtable _printedTags = new Hashtable();

		private static Thread _printThreadCT;

		private static Thread _printThreadBTRF;

		/// <summary>
		/// Flag indicating whether situation when no logon user division code is defined will cause an exception.
		/// </summary>
		private static bool _noLogonUserDefined = false;

		/// <summary>
		/// Flag indicating whether 508 compliance should be turned on/off.
		/// </summary>
		private static bool _isVisuallyImpairedUser = false;

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8122"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8123"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Specifies whether or not global logon user is defined (logon user is not defined in the MUC UCs) and 
		/// effectively whether or not a call to uninitialized <see cref="LogonUserDivisionCode"/> will 
		/// cause an exception.
		/// </summary>
		public static bool NotDefined
		{
			get
			{
				return _noLogonUserDefined;
			}
			set
			{
				_noLogonUserDefined = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="526"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>LogonUserDivisionCode</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="527"> 
		///		<ExpectedInput>Empty String</ExpectedInput>
		///		<ExpectedOutput>ArgumentOutOfRangeException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="528"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets or sets the division code of the logged on user.
		/// </summary>
		public static string LogonUserDivisionCode
		{
			get
			{

				if( !_noLogonUserDefined && ( _logonUserDivisionCode == String.Empty || _logonUserDivisionCode == null ) )

				{
#if NUNIT
					_logonUserDivisionCode = string.Empty;
#else
					throw( new BaseApplicationException( StrRes.SysErrMsg.Common.GlobalLogonUserDivisionCodeIsNotSaved().ResString ) );
#endif
				}

				return _logonUserDivisionCode;				
			}
			set
			{
				if( !_noLogonUserDefined && value == null )
					throw( new ArgumentNullException() );

				if( !_noLogonUserDefined && value == String.Empty ) 
					throw( new ArgumentOutOfRangeException() );

				_logonUserDivisionCode = value;
			}
		}

		///<Case type="0" testid ="8848"> 
		///		<ExpectedInput>Boolean</ExpectedInput>
		///		<ExpectedOutput>Boolean</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8849"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		/// <summary>
		/// Returns whether user is visually impaired
		/// </summary>
		public static bool IsVisuallyImpairedUser
		{
			get
			{

				return _isVisuallyImpairedUser;		
			}
			set
			{
				_isVisuallyImpairedUser = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8357"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8358"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the user name of the logged on user.
		/// </summary>
		public static System.Guid VbecsSessionGuid
		{
			get
			{
				if (_vbecsSessionGuid == System.Guid.Empty)
				{
					_vbecsSessionGuid = System.Guid.NewGuid();
				}

				return(_vbecsSessionGuid);
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="529"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>LogonUserName</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="530"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the user name of the logged on user.
		/// </summary>
		public static string LogonUserName
		{
			get
			{
				return Environment.UserName;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8124"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8125"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets the VistA DUZ of the logged on user.
		/// </summary>
		public static string LogonUserDUZ
		{
			get
			{

				return _logonUserDuz;		
			}
			set
			{
				_logonUserDuz = value;
			}
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/27/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5596"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>HashTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5597"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// This stores the units that have been printed in the current
		/// session.
		/// BR_3.13
		///</summary>
		public static Hashtable PrintedTags
		{
			get
			{
				return _printedTags;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8126"> 
		///		<ExpectedInput>Thread</ExpectedInput>
		///		<ExpectedOutput>Thread</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8127"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This is the thread used to print backup caution tags.  This function
		/// is implemented this way so it can be easily stopped if an emergency
		/// issue tag needs to be printed.
		/// </summary>
		public static Thread PrintThreadCT
		{
			get
			{
				return _printThreadCT;
			}
			set
			{
				_printThreadCT = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8128"> 
		///		<ExpectedInput>Thread</ExpectedInput>
		///		<ExpectedOutput>Thread</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8129"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This is the thread used to print backup Blood Transfusion Record Forms.
		/// This function is implemented this way so it can be easily stopped if an 
		/// emergency issue tag needs to be printed.
		/// </summary>
		public static Thread PrintThreadBTRF
		{
			get
			{
				return _printThreadBTRF;
			}
			set
			{
				_printThreadBTRF = value;
			}
		}
	}
}
